
function setup() {
  createCanvas(900, 900);
  noLoop(); // Only draw once

  noiseSeed(12345); // Fixed seed makes randomness reproducible
  drawGradientBackground();

  // Draw 200 shapes randomly scattered across the canvas
  for (let i = 0; i < 200; i++) {
    let x = random(width);
    let y = random(height);

   
    let size = map(noise(x * 0.01, y * 0.01), 0, 1, 10, 150);
    let angle = noise(x * 0.005, y * 0.005) * TWO_PI;

    push();
    translate(x, y);    // Move to random position
    rotate(angle);      // Apply gentle rotation
    drawOrganicShape(size); // Draw shape
    pop();
  }
}

// Draw a smooth vertical gradient background
function drawGradientBackground() {
  for (let y = 0; y < height; y++) {
    let t = map(y, 0, height, 0, 1);
    let gradientColor = lerpColor(color(245), color(30), t); // Light to dark gray
    stroke(gradientColor);
    line(0, y, width, y);
  }
}

// Create an irregular circular shape using Perlin noise
function drawOrganicShape(size) {
  noFill();
  strokeWeight(map(size, 10, 150, 0.5, 2.5)); // Thicker strokes for larger shapes
  stroke(0, 100); // Semi-transparent black stroke

  beginShape();
  for (let angle = 0; angle < TWO_PI; angle += PI / 10) {
    let noiseFactor = 0.7 + noise(cos(angle), sin(angle)) * 0.3;
    let radius = size * noiseFactor;
    let x = radius * cos(angle);
    let y = radius * sin(angle);
    vertex(x, y);
  }
  endShape(CLOSE);
}
