let dots = [];

function setup() {
  createCanvas(600, 400);
  noFill();
  stroke(255);

  // Create an initial set of dots
  for (let i = 0; i < 50; i++) {
    dots.push({
      x: random(width),
      y: random(height),
      diameter: random(10, 40),
      speedX: random(-2, 2),
      speedY: random(-2, 2)
    });
  }
}

function draw() {
  background(0);

  // Draw looping ellipses across the canvas
  for (let i = 0; i < width; i += 60) {
    ellipse(i, height / 2, 50);
  }

  // Animate all dots in the array
  fill(255);
  noStroke();
  for (let dot of dots) {
    ellipse(dot.x, dot.y, dot.diameter);
    dot.x += dot.speedX;
    dot.y += dot.speedY;

    // Bounce off edges
    if (dot.x < 0 || dot.x > width) dot.speedX *= -1;
    if (dot.y < 0 || dot.y > height) dot.speedY *= -1;
  }
}

// Add new dot on mouse click
function mousePressed() {
  dots.push({
    x: mouseX,
    y: mouseY,
    diameter: random(10, 40),
    speedX: random(-2, 2),
    speedY: random(-2, 2)
  });
}
